# Trend Micro Artifact Scanner (TMAS) Release Notes

## [v2.197.0] - 2026-02-06

### Changed

- **Vision One endpoints are now the default**: The TMAS cli now uses Vision One endpoint format by default for all API operations
  - Scan operations now connect to Vision One infrastructure (`api.xdr.trendmicro.com` and regional variants)
  - Version update checks now use Vision One infrastructure

## [v2.192.0] - 2026-02-04

### Removed

- **Cloud One API Key Support**: Support for Cloud One API keys has been removed. All users must now use Vision One API keys.

  Follow the instructions at [Obtaining API Keys for Trend Vision One](https://docs.trendmicro.com/en-us/documentation/article/trend-vision-one-obtaining-api-key) to obtain a Vision One API key.

## [v2.183.0] - 2025-12-17

This release allows you to perform `aiscan llm` scan operations in the 'ca-central-1' and 'eu-west-2' regions.

## [v2.181.0] - 2025-12-15

### Added

- **Artifact Metadata Display**: Vulnerability scans now include artifact metadata in the output, providing detailed information about scanned container images.
  - **Metadata Includes**:
    - **Image ID**: Unique identifier for the image
    - **Tags**: All tags associated with the image
    - **OS**: Operating system (e.g., "linux")
    - **Architecture**: CPU architecture (e.g., "arm64", "amd64")
    - **Image Digest**: SHA256 digest of the image
    - **Created**: Timestamp when the image was created

  - **Artifact Type Support**:
    - Container images: Full metadata displayed (Docker, OCI archives, registry images)
    - Files and directories: Metadata field omitted entirely

  - **Example Output**:

    ```json
    {
      "artifactMetadata": {
        "artifactID": "sha256:9c6f07244728...",
        "imageID": "sha256:9c6f07244728...",
        "tags": [
          "alpine:latest",
          "alpine:3.19"
        ],
        "os": "linux",
        "architecture": "arm64",
        "imageDigest": "sha256:1234567890ab...",
        "created": "2024-01-15T10:23:45Z"
      },
      "vulnerabilities": {
        "totalVulnCount": 0,
        ...
      }
    }
    ```

  - **Notes**:
    - Metadata is omitted entirely when not available (e.g., for file scans or when scan fails)
    - Malware and secrets subcommands remain unchanged

## [v2.180.0] - 2025-12-11

This release allows you to perform vulnerability, malware and secrets scan operations in the newly released V1 region 'ca-central-1'.

### Changed

The `--region` flag has a new supported value: `ca-central-1`

## [v2.165.0] - 2025-11-12

### Added

- The `aiscan llm` command now supports scanning custom AI application endpoints.
  - **Interactive Workflow**: When running `tmas aiscan llm -i`, you can now choose between:
    - **OpenAI**: For scanning OpenAI-compliant model endpoints
    - **Custom**: For scanning custom AI application endpoints

  - **Custom Provider Features**:
    - Configure custom application targets with user-defined request and response schema either in interactive mode or config file mode
    - Alphanumeric names (letters, numbers, and spaces) for easy target identification
    - Maximum name length of 64 characters for consistent naming

  - **Configuration Methods**:
    - **Interactive Mode**: Use the `-i` flag to configure targets through an interactive workflow
    - **Config File**: Use the `-c` flag to specify a configuration file for automated scanning

  - **Usage Examples**:

    ```bash
    # Interactive configuration
    tmas aiscan llm -i

    # Select "Custom" when prompted for target type
    # Follow the prompts to configure your custom application and model endpoints

    # Config file-based scanning
    # Add your request and response schema to the config file
    tmas aiscan llm -c path/to/config.yaml
    ```

  - This feature enables scanning of custom request and response schema AI application endpoints, extending TMAS capabilities beyond standard OpenAI-compatible models.

## [v2.162.0] - 2025-10-31

This release allows you to perform vulnerability, malware and secrets scan operations in the newly released V1 region 'eu-west-2'.

### Changed

The `--region` flag has a new supported value: `eu-west-2`

## [v2.153] - 2025-10-01

### Added

- The `aiscan llm` command now supports the `--output` flag, allowing you to save scan results to files in JSON and Markdown formats.
  - **Usage Examples**:

    ```bash
    # Save results as JSON
    tmas aiscan llm -i --output json=ai-scan-results.json

    # Save results as Markdown report
    tmas aiscan llm -i --output markdown=ai-scan-report.md

    # Save results in both formats
    tmas aiscan llm -i --output json=results.json,markdown=report.md
    ```

  - The json output provides a complete summary of the scan results, while the markdown format shows a limited number of successful attacks (if any) for preview purposes.

## [v2.1XX.0] - 2025-07-XX

This release increases the allowed SBOM size in the vulnerabilities scanner from 10MB to 15MB, allowing for more complex artifacts to be scanned.

## [v2.122.0] - 2025-07-14

This release introduces the new `--redacted` flag, allowing you to redact secret finding values from the TMAS cli output before it becomes enabled by default in the next major release.

### Added

- You can now use the `--redacted` flag to redact secret finding values from the TMAS cli output.
  - **Usage Example**:

    ```bash
    tmas scan <artifact-to-scan> -S --redacted
    ```

    ```bash
    tmas scan secrets <artifact-to-scan> --redacted
    ```

  - **Previous Output**:

  ```json
  {
    "secrets": {
      "totalFilesScanned": 1,
      "unmitigatedFindingsCount": 1,
      "overriddenFindingsCount": 0,
      "findings": {
        "unmitigated": [
          {
            "ruleID": "curl-auth-user",
            "description": "Discovered a potential basic authorization token provided in a curl command, which could compromise the curl accessed resource.",
            "secret": "username:fakepwd",
            "location": {
              "layerID": "sha256:9cd9df9ffc972e9abc946d855162ef0c40dff9a89f10c962b7920154a3d943d8",
              "path": "/usr/share/doc/curl/MANUAL",
              "startLine": 99,
              "endLine": 105,
              "startColumn": 47,
              "endColumn": 66
            }
          }
        ]
      }
    }
  }
  ```

  - **New Output**:

  ```json
  "secrets": {
    "totalFilesScanned": 1,
    "unmitigatedFindingsCount": 1,
    "overriddenFindingsCount": 0,
    "findings": {
      "unmitigated": [
        {
          "ruleID": "curl-auth-user",
          "description": "Discovered a potential basic authorization token provided in a curl command, which could compromise the curl accessed resource.",
          "secret": "us******wd",
          "location": {
            "layerID": "sha256:9cd9df9ffc972e9abc946d855162ef0c40dff9a89f10c962b7920154a3d943d8",
            "path": "/usr/share/doc/curl/MANUAL",
            "startLine": 99,
            "endLine": 105,
            "startColumn": 47,
            "endColumn": 66
          }
        }
      ]
    }
  }
  ```

- The `--redacted` flag is a pre-release feature. In the next major release, this feature will be enabled by default on all secret scan operations.

## [v2.117.0] - 2025-07-07

This release introduces the `aiscan llm` feature. This new command allows you to scan an LLM endpoint for security vulnerabilities. This feature is available for pre-release. Please contact us to join!

### Added

- **LLM Endpoint Vulnerability Scan (Pre-release feature)**: You can now use the `aiscan llm` command to identify security vulnerabilities in your LLM endpoint relating to frameworks such as the [OWASP Top 10 FOR LLM Applications](https://genai.owasp.org/llm-top-10/) and [MITRE ATLAS](https://atlas.mitre.org/matrices/ATLAS).

- **Usage Example**:

  ```bash
  tmas aiscan llm -i
  ```

## [v2.115.0] - 2025-07-04

This release introduces the new `--evaluatePolicy` flag, allowing you to preview the policy evaluation functionality before it becomes enabled by default in the next major release.

### Added

- **Policy Evaluation (Pre-release Feature)**: You can now use the `--evaluatePolicy` flag to have TMAS evaluate your scan results against your organization's Vision One Code Security policy. If any blocking rules are violated, TMAS will report the violations and exit with status code '2', making it easy to enforce policy compliance in your CI/CD pipelines. Policy evaluation is available for the vulnerabilities, secrets, and malware scanners.
  - **Usage Example**:

    ```bash
    tmas scan <artifact-to-scan> -VMS  --evaluatePolicy
    ```

    ```bash
    tmas scan vulnerabilities <artifact-to-scan> --evaluatePolicy
    ```

  - The `--evaluatePolicy` flag is a pre-release feature and is only supported with Trend Vision One accounts. In the next major release, policy evaluation will run automatically on vulnerabilities, secrets, and malware scans and this flag will be deprecated.

## [v2.70.0] - 2025-04-10

This release now generates Software Bill Of Materials (SBOM) using the CycloneDX 1.6 specifications.

[Reference](https://cyclonedx.org/docs/1.6/json/)

## [v2.65.0] - 2025-03-24

This release allows you to perform vulnerability, malware and secrets scan operations in the newly released V1 region 'me-central-1'.

### Changed

The `--region` flag has a new supported value: `me-central-1`

## [v2.64.0] - 2025-03-21

This release adds a new `--distro` flag for the vulnerabilities scanner, allowing users to specify Operating System (OS) distribution details for file and directory artifacts which do not inherently contain OS information, such as open-source RPM files.

### Added

- **New `--distro` Flag**: This flag allows users to specify OS distribution details for file and directory artifacts, aiding TMAS in identifying vulnerabilities in open-source RPM files.
  - **Usage**:
    - The `--distro` flag can be specified when running the vulnerabilities scanner. For example:
      ```bash
      tmas scan -V file:sample-file.rpm --distro ol:8.1
      tmas scan vulnerabilities file:sample-file.rpm --distro ol:8.1
      ```
    - Specify the exact operating system distribution where you plan to install the package to ensure accurate open-source vulnerability matching.
    - The `--distro` flag can only be used when scanning directory and file artifacts for vulnerabilities.

  - **Important Notes**:
    - This flag is intended for scanning _unmodified_ open-source RPM files prior to their installation.
    - When scanning the root directory of a file-system (e.g., `tmas scan -V dir:/`), TMAS will automatically detect the operating system distribution information based on the contents of the `/etc/os-release` file. Any value specified using the `--distro` flag will be ignored, and a warning will be presented.

## [v2.0.0] - 2024-07-15

This release adds enhanced support for custom scanner combinations including the newly released secrets scanner. Pipelines can run scanners independently or together, ensuring comprehensive security coverage tailored to their specific needs. This version also provides more intuitive and standardized scan result output.

### Changed

- **Improved CLI Scan Command Structure**: The CLI tool now uses a more intuitive scan command structure that allows you to run custom combinations of scanners together or independently, with at least one scanner enabled.
  - **Previous Command Structure**:
    - To run the vulnerabilities scanner, you would use the `tmas scan` command:
      ```bash
      tmas scan <artifact-to-scan>
      ```
    - To run the vulnerabilities scanner with the malware scanner, you would use the `--malwareScan` flag with the `tmas scan` command:
      ```bash
      tmas scan <artifact-to-scan> --malwareScan
      ```
    - You could not run the vulnerabilities scanner with the secrets scanner or the malware scanner with the secrets scanner.
    - You could run each scanner individually using the `malware`, `vulnerabilities`, and `secrets` subcommands.

  - **New Command Structure**:
    - Introducing three new flags that can be used with `tmas scan`:
      - `--malware` or `-M`: Enables the malware scanner. Supports `docker`, `docker-archive`, `oci-archive`, `oci-dir` and `registry` artifact types.
      - `--vulnerabilities` or `-V`: Enables the vulnerabilities scanner.
      - `--secrets` or `-S`: Enables the secrets scanner.
    - At least one of the above flags must be enabled to run the `tmas scan` command.
    - You can use any combination of the above flags with the `tmas scan` command to run the scanners together. For example, to run the malware scanner with the vulnerabilities scanner, you can execute:
      ```bash
      tmas scan <artifact-to-scan> --malware --vulnerabilities
      ```
    - You can also use the short-hand version of the above flags with the `tmas scan` command. For example, to run the malware, vulnerabilities, and secrets scanners, you can execute:
      ```bash
      tmas scan <artifact-to-scan> -MVS
      ```
  - You can continue to use the `malware`, `vulnerabilities`, and `secrets` subcommands to run individual scanners. For example:
    - To run the malware scanner:
      ```bash
      tmas scan malware <artifact-to-scan>
      ```
    - To run the vulnerabilities scanner:
      ```bash
      tmas scan vulnerabilities <artifact-to-scan>
      ```
    - To run the secrets scanner:
      ```bash
      tmas scan secrets <artifact-to-scan>
      ```

- **Unified Output Structure**: The CLI tool now organizes scan result JSON output under a high-level key corresponding to each scanner's name. This change enhances the clarity and consistency of scan results, making it easier to parse and understand the output regardless of the command used to trigger the scanner. For example:
  - **Previous Output**:
    - For `tmas scan <artifact-to-scan>`:

    ```json
    {
      "totalVulnCount": 0,
      "criticalCount": 0,
      "highCount": 0,
      "mediumCount": 0,
      "lowCount": 0,
      "negligibleCount": 0,
      "unknownCount": 0,
      "overriddenCount": 0,
      "findings": {}
    }
    ```

    - For `tmas scan <artifact-to-scan> --malwareScan`:

    ```json
    {
      "vulnerability": {
        "totalVulnCount": 0,
        "criticalCount": 0,
        "highCount": 0,
        "mediumCount": 0,
        "lowCount": 0,
        "negligibleCount": 0,
        "unknownCount": 0,
        "overriddenCount": 0,
        "findings": {}
      },
      "malware": {
        "scanResult": 0,
        "scanID": "67eefe36-1ce0-4455-af9d-ab81ff18aca4",
        "scannerVersion": "1.0.0-62"
      }
    }
    ```

  - **New Unified Output**:
    - For `tmas scan <artifact-to-scan> -VMS`:
      ```json
      {
        "vulnerabilities": {
          "totalVulnCount": 0,
          "criticalCount": 0,
          "highCount": 0,
          "mediumCount": 0,
          "lowCount": 0,
          "negligibleCount": 0,
          "unknownCount": 0,
          "overriddenCount": 0,
          "findings": {}
        },
        "malware": {
          "scanResult": 0,
          "scanID": "67eefe36-1ce0-4455-af9d-ab81ff18aca4",
          "scannerVersion": "1.0.0-62"
        },
        "secrets": {
          "totalFilesScanned": 2405,
          "unmitigatedFindingsCount": 0,
          "overriddenFindingsCount": 0,
          "findings": {}
        }
      }
      ```
    - If a scanner is disabled, its high-level key will not be present in the report. For example, `tmas scan <artifact-to-scan> -VM` will produce the output:
      ```json
      {
        "vulnerabilities": {
          "totalVulnCount": 0,
          "criticalCount": 0,
          "highCount": 0,
          "mediumCount": 0,
          "lowCount": 0,
          "negligibleCount": 0,
          "unknownCount": 0,
          "overriddenCount": 0,
          "findings": {}
        },
        "malware": {
          "scanResult": 0,
          "scanID": "67eefe36-1ce0-4455-af9d-ab81ff18aca4",
          "scannerVersion": "1.0.0-62"
        }
      }
      ```

### Removed

- The CLI no longer supports the `--malwareScan` flag. Instead, you can run the malware scanner using any of the following methods:
  - Using the `tmas scan malware` subcommand. For example, `tmas scan malware <artifact-to-scan>`; or
  - Enabling the malware scanner in the `tmas scan` command using the new `--malware` or `-M` flag. For example, `tmas scan <artifact-to-scan> --malware` or `tmas scan <artifact-to-scan> -M`. This method allows you to optionally run the malware scanner alongside other scanners.
- The CLI no longer supports the `CLOUD_ONE_API_KEY` environment variable. Instead, you can use the `TMAS_API_KEY` environment variable to specify your Trend Vision One or Trend Cloud One API key.
